// ConfigureEntranceAccess.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "ConfigureEntranceAccess.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigureEntranceAccess dialog


CConfigureEntranceAccess::CConfigureEntranceAccess(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigureEntranceAccess::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigureEntranceAccess)
	m_Exist_Tz = _T("");
	m_AcclName = _T("");
	m_sExGroup = _T("");
	//}}AFX_DATA_INIT
}
CConfigureEntranceAccess ::CConfigureEntranceAccess(IApplication *pApp):CDialog(CConfigureEntranceAccess::IDD, NULL)
{
	pApplication = pApp;
}

void CConfigureEntranceAccess::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigureEntranceAccess)
	DDX_Control(pDX, IDC_EXIST_GROUP, m_EditExGrp);
	DDX_Control(pDX, IDC_GROUPS, m_GrpList);
	DDX_Control(pDX, IDC_ACCL_NAME, m_Ctn_AcclName);
	DDX_Control(pDX, IDC_EXIST_TZ, m_cnt_ExTZ);
	DDX_Control(pDX, IDC_TIMEZONES, m_Timezones);
	DDX_Control(pDX, IDC_READERS, m_ReaderList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	DDX_Control(pDX, IDC_ACCLLIST, m_AcclList);
	DDX_Text(pDX, IDC_EXIST_TZ, m_Exist_Tz);
	DDX_Text(pDX, IDC_ACCL_NAME, m_AcclName);
	DDX_Text(pDX, IDC_EXIST_GROUP, m_sExGroup);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CConfigureEntranceAccess, CDialog)
	//{{AFX_MSG_MAP(CConfigureEntranceAccess)
	ON_CBN_SELCHANGE(IDC_ACCLLIST, OnSelchangeAccllist)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST, OnSelchangeSubAcctlist)
	ON_BN_CLICKED(ID_CONF_ENTRANCE, OnConfEntrance)
	ON_CBN_SELCHANGE(IDC_READERS, OnSelchangeReaders)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigureEntranceAccess message handlers
BOOL CConfigureEntranceAccess::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

}
void CConfigureEntranceAccess::LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctid;
				sAcctid.Format(L"%ld",pAccount->AccountID);
				m_AcctList.AddString(sAcctid);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}
void CConfigureEntranceAccess::LoadSubAccounts(long lAcctID)
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
		pApplication->GetSubAccountsByAccountID(lAcctID,&vSubAccounts); // get account details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pSubAccount = NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount != NULL)
			{
				m_SubAcctList.AddString(pSubAccount->AccountName);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}
void CConfigureEntranceAccess ::LoadAccessLevels()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

		//select subaccount name 
		int subacct_index = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(subacct_index,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();

		_variant_t vAccls;
		vAccls.Clear();
		pApplication->GetAccessLevelsByAccountName(bstrAcctName,bstrSubAcctName,&vAccls); // get access levels details of particular account  in WP-CS database server
		
		if(vAccls.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccessLevel *pAccl = NULL;
		
		COleSafeArray sa(vAccls);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccessLevel,(void**)&pAccl);
			if (pAccl != NULL)
			{
				//m_AcclList.AddString(pAccl->AccessLevelName);
				CString sAcclid;
				sAcclid.Format(L"%ld",pAccl->AccessLevelID);
				m_AcclList.AddString(sAcclid);
				pAccl->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_AcclList.SetCurSel(0);
}
void CConfigureEntranceAccess::LoadReaders()
{
	//select account name 
	int index = m_AcctList.GetCurSel();
	CString sAcctID;
	m_AcctList.GetLBText(index,sAcctID);
	long lAccountID = _wtol(sAcctID);
	BSTR bstrAcctName;
	pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
	// This Name for get all readers configured in Access area
	//Because then only we configure the access  level for selected reader in access area

	BSTR bstrAccessArea = SysAllocString(L"AccessArea"); 
	_variant_t vReaders;
	vReaders.Clear();
	//to get all readers in Access area
	pApplication->GetReadersInAccessAreaBranch(bstrAcctName,bstrAccessArea,&vReaders);
		
		if(vReaders.vt == VT_EMPTY)
		{
			AfxMessageBox(L"No Readers");
			return;
		}
		
		long uBound =0 ;
		
		COleSafeArray sa(vReaders);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		BSTR bstrReader;
		for(long i =0 ;i <= uBound ; i++)
		{
			sa.GetElement(&i,(void*)&bstrReader);
			CString sReader = CString(bstrReader);
			//AfxMessageBox(scard);
			m_ReaderList.AddString(sReader);
		}
		
}
void CConfigureEntranceAccess::OnSelchangeAccllist() 
{
	long lAcclID=0;
	BSTR bstrAcclName; 
	int index_Accl = m_AcclList.GetCurSel();
	CString sAcclid;
	if(index_Accl >=0)
	{
		m_AcclList.GetLBText(index_Accl,sAcclid);
		lAcclID = _wtoi(sAcclid);
	}

	//get the AL Name by ALID
	pApplication->GetAccessLevelNameByID(lAcclID,&bstrAcclName);
	UpdateData(TRUE);	
	m_AcclName = CString (bstrAcclName);
	UpdateData(FALSE);
	m_ReaderList.ResetContent();
	LoadReaders();
	m_cnt_ExTZ.SetWindowText(L"");
	m_Timezones.ResetContent();
		
}

void CConfigureEntranceAccess::OnSelchangeAcctlist() 
{
	int index_Acct = m_AcctList.GetCurSel();
	CString sAcctid;

	m_AcctList.GetLBText(index_Acct,sAcctid);
	long lAccountID = _wtoi(sAcctid);

	/*m_AcclList.ResetContent();
	LoadAccessLevels();
	m_ReaderList.ResetContent();
	m_Timezones.ResetContent();
	m_cnt_ExTZ.SetWindowText("");
	m_Ctn_AcclName.SetWindowText("");*/

	m_SubAcctList.ResetContent();
	LoadSubAccounts(lAccountID);

}

void CConfigureEntranceAccess::OnSelchangeSubAcctlist() 
{
	m_AcclList.ResetContent();
	LoadAccessLevels();
	m_ReaderList.ResetContent();
	m_Timezones.ResetContent();
	m_cnt_ExTZ.SetWindowText(L"");
	m_Ctn_AcclName.SetWindowText(L"");

}

void CConfigureEntranceAccess ::LoadAvailReaderTZs()
{
	//select account name 
	int acct_index = m_AcctList.GetCurSel();
	CString sAcctID;
	m_AcctList.GetLBText(acct_index,sAcctID);
	long lAccountID = _wtol(sAcctID);
	BSTR bstrAcctName;
	pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

	//select Reader name 
	int index = m_ReaderList.GetCurSel();
	CString sReaderName;
	m_ReaderList.GetLBText(index,sReaderName);
	BSTR bstrReaderName = sReaderName.AllocSysString();

	_variant_t vTzs;
	vTzs.Clear();
	pApplication->GetAvailableTimeZonesOfAccessReader(bstrAcctName,bstrReaderName,&vTzs);

	if(vTzs.vt ==  VT_EMPTY)
		{
			AfxMessageBox(L"No Timezones Available");
			return;
		}
		
		long uBound =0 ;
		ITimeZone *pTz = NULL;
		
		COleSafeArray sa(vTzs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ITimeZone,(void**)&pTz);
			if (pTz != NULL)
			{
				m_Timezones.AddString(pTz->TimeZoneName);
				pTz->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_Timezones.SetCurSel(0);
}
void CConfigureEntranceAccess::OnConfEntrance() 
{
		UpdateData(TRUE);
		BSTR bstrTzName;	
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
		//select time zone name 
		int index_Tz = m_Timezones.GetCurSel();
		CString sTZName;
		if (index_Tz <0)
			bstrTzName = SysAllocString(L"");
		else
		{
			m_Timezones.GetLBText(index_Tz,sTZName);
			bstrTzName = sTZName.AllocSysString();
		}
	
		//select Access level ID
		BSTR bstrAcclName;
		int index_Accl = m_AcclList.GetCurSel();
		if (index_Accl <0)
			bstrAcclName = SysAllocString(L"");
		else
		{
			CString sAcclid;
			m_AcclList.GetLBText(index_Accl,sAcclid);
			long lAcclID = _wtoi(sAcclid);
			//get access level name by ID
			pApplication->GetAccessLevelNameByID(lAcclID,&bstrAcclName);
		}
		
		VARIANT vReader;
		CString sReaderName;
		BSTR bstrReaderName;
		int index_Reader = m_ReaderList.GetCurSel();
		if (index_Reader <0)
		{
			bstrReaderName= SysAllocString(L"");
			vReader.vt = VT_EMPTY;
		}
		else
		{
			m_ReaderList.GetLBText(index_Reader,sReaderName);
			bstrReaderName = sReaderName.AllocSysString();
		}

		int index_Grp = m_GrpList.GetCurSel();
		BSTR bstrGrpName;
		CString sGrpName;
		if(m_GrpList.GetCount() == 0 || index_Grp < 0)
		{
			bstrGrpName = NULL;
		}
		else
		{
			m_GrpList.GetLBText(index_Grp, sGrpName);
			if(sGrpName == _T("No Group"))
				bstrGrpName = CString(L"").AllocSysString();
			else
			{
				bstrGrpName = sGrpName.AllocSysString();
			}	
		}

		//configure the access level 
		long lStatus;
		//pApplication->ConfigureAccessLevel(bstrAcclName,vReader,bstrTzName,&lStatus);
		pApplication->ConfigureEntranceAccess(bstrAcclName,bstrAcctName, bstrReaderName, bstrTzName, bstrGrpName, &lStatus);
		if (lStatus == 201)
		{
			AfxMessageBox(L"Invalid access level Name");
			return;
		}
		if (lStatus == 208)
		{
			AfxMessageBox(L"Reader Name Empty");
			return;
		}
		if (lStatus == 207)
		{
			AfxMessageBox(L"Invalid Access Reader");
			return;
		}
		if (lStatus == 209)
		{
			AfxMessageBox(L"Invalid Group Name");
			return;
		}
		if (lStatus == 210)
		{
			AfxMessageBox(L"Invalid Timezone Name");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Configure Entrance Access level failed");
			return;
		}
		if( lStatus == 0)
		{
			AfxMessageBox(L"Configure Entrance Access level Succeded");
			CDialog ::OnOK();
		}
}

void CConfigureEntranceAccess::OnSelchangeReaders() 
{
	
	m_Timezones.ResetContent();
	LoadAvailReaderTZs();
	m_GrpList.ResetContent();
	LoadAvailReaderGroups();
	GetExistTZofReader();
	GetExistGroupOfReader();

}

void CConfigureEntranceAccess ::GetExistTZofReader()
{
		//select account name 
		int index_acct = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index_acct,sAcctName);
		BSTR bstrAcctName = sAcctName.AllocSysString();
		//select Access level ID
		BSTR bstrAcclName;
		int index_Accl = m_AcclList.GetCurSel();
		if (index_Accl <0)
			bstrAcclName = SysAllocString(L"");
		else
		{
			CString sAcclid;
			m_AcclList.GetLBText(index_Accl,sAcclid);
			long lAcclID = _wtoi(sAcclid);
			//get access level name by ID
			pApplication->GetAccessLevelNameByID(lAcclID,&bstrAcclName);
		}
		
		//select Reader name
		BSTR bstrReaderName;
		int index_reader = m_ReaderList.GetCurSel();
		CString sReaderName;
		m_ReaderList.GetLBText(index_reader,sReaderName);
		bstrReaderName = sReaderName.AllocSysString();
		_variant_t vTz;
		vTz.Clear();
		pApplication->GetAssociatedTimeZoneOfReader(bstrAcclName,bstrAcctName,bstrReaderName,&vTz);
		if(vTz.vt ==  VT_EMPTY)
		{
			return;
		}
		UpdateData(TRUE);
		if( vTz.vt & VT_DISPATCH)
		{
			ITimeZonePtr pTz(vTz.pdispVal);
			m_Exist_Tz =CString(((LPWSTR)pTz->TimeZoneName));
			
		}
		UpdateData(FALSE);

		if(NULL != vTz.pdispVal)
		{
			//vTz.pdispVal->Release();
			vTz.Clear();
		}
}

void CConfigureEntranceAccess::LoadAvailReaderGroups()
{
	int index = m_ReaderList.GetCurSel();
	CString sReaderName;
	m_ReaderList.GetLBText(index,sReaderName);
	BSTR bstrReaderName = sReaderName.AllocSysString();

	_variant_t vGrps;
	vGrps.Clear();
	pApplication->GetAvailableGroupsofReader(bstrReaderName, &vGrps);
	// Fix for No Group Sysytems -- Guru
	m_GrpList.AddString(_T("No Group"));
	if(vGrps.vt ==  VT_EMPTY)
	{
		AfxMessageBox(_T("No Groups Available"));	
		return;
	}
		
	long uBound =0 ;
	IHWDevice *pDevice = NULL;
	
	COleSafeArray sa(vGrps);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	
	for(long i =0 ;i <= uBound ; i++)	
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IHWDevice,(void**)&pDevice);
		if (pDevice != NULL)
		{
			m_GrpList.AddString(pDevice->DeviceName);
			pDevice->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
	m_GrpList.SetCurSel(0);
}

void CConfigureEntranceAccess::GetExistGroupOfReader()
{
	//select account name 
	int index = m_AcctList.GetCurSel();
	CString sAcctID;
	m_AcctList.GetLBText(index,sAcctID);
	long lAccountID = _wtol(sAcctID);
	BSTR bstrAcctName;
	pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

	BSTR bstrAcclName;
	int index_Accl = m_AcclList.GetCurSel();
	if (index_Accl <0)
		bstrAcclName = SysAllocString(L"");
	else
	{
		CString sAcclid;
		m_AcclList.GetLBText(index_Accl,sAcclid);
		long lAcclID = _wtoi(sAcclid);
		//get access level name by ID
		pApplication->GetAccessLevelNameByID(lAcclID,&bstrAcclName);
	}

	//select Reader name
	BSTR bstrReaderName;
	int index_reader = m_ReaderList.GetCurSel();
	CString sReaderName;
	m_ReaderList.GetLBText(index_reader,sReaderName);
	bstrReaderName = sReaderName.AllocSysString();

	long lGrpID = 0;
	pApplication->GetAssociatedGroupofReader(bstrAcclName,bstrAcctName,bstrReaderName,&lGrpID);
	if(lGrpID ==  0)
	{
		m_sExGroup = _T("No Group");
	}
	else
	{
		BSTR bstrGrpName;
		pApplication->GetDevNameByDeviceID(lGrpID, &bstrGrpName);
		m_sExGroup = (CString) bstrGrpName;
	}
	UpdateData(FALSE);
}
